<?php

namespace App\Console\Commands;

use App\Models\Docs;
use App\Models\VehiculoGeneral;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;

class cargarDocumentacion extends Command
{
    var $timestampUnique = 0;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'cargar:documentos';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->timestampUnique = Carbon::now('GMT-6');
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        //Leer directorios con archivos
        $dir = base_path() ."\..\..\..\Users\Andres Herrrera\OneDrive - Transportes Lipu S.A. de C.V\Documentos\DocumentosSIGO\Pólizas Lipu Saltillo";
        Log::channel('vehiculosfiles')->info($dir);
        $this->insertarArchivosPoliza($dir, 0);
        Log::info("-----------------------------------------------------------------");
/*         $dir = base_path() ."\..\..\..\Users\Andres Herrrera\OneDrive - Transportes Lipu S.A. de C.V\Documentos\DocumentosSIGO\TC LIPU SALTILLO 15.03.2023";
        Log::channel('vehiculosfiles')->info($dir);
        $this->insertarArchivosTarjeta($dir, 0);
        return 0; */
    }

    public function insertarArchivosTarjeta($path){
        $dir = opendir($path);
        while ($current = readdir($dir)) {
            if ($current != "." && $current != "..") {
                if (is_file($path . DIRECTORY_SEPARATOR . $current)) {
                
                    $data = explode(".",$current);
                    $eco = $data[1]; 

                    Log::channel('vehiculosfiles')->info("ECO: ".$eco);

                    $vehiculo_info = VehiculoGeneral::where('fk_entity_company', '17040')->where('eco', $eco)->get();
                    Log::channel('vehiculosfiles')->info("ID: ".$vehiculo_info[0]->pk_vehicle);
                    Log::channel('vehiculosfiles')->info("Archivo: ".$current);

                    if(VehiculoGeneral::where('fk_entity_company', '17040')->where('eco', $eco)->exists()){
                        $tarjeta = new Docs();
                        $tarjeta->fk_vehicle = $vehiculo_info[0]->pk_vehicle;
                        $tarjeta->document_module = 'TARJETA DE CIRULACIÓN';
                        $doc_file = new UploadedFile($path. DIRECTORY_SEPARATOR.$current, $current, 'application/pdf', null, false);
                        $tarjeta->name_file = $current;
                        $tarjeta->created_at = Carbon::now();
                        $filePath =  'TMS/Activos/vehiculos/'.$vehiculo_info[0]->pk_vehicle.'/TarjetasCirculacion/'.date("Y").'/Enero';
                        //Valida si este archivo ya fue cargado con anterioridad
                        if(Storage::disk('s3')->exists($filePath."/".$current)){
                            Log::channel('vehiculosfiles')->info("Tarjeta existente");
                            $url_s3_poliza = Storage::disk('s3')->path($filePath."/".$current);
                        }else{
                            Log::channel('vehiculosfiles')->info("Tarjeta nueva");
                            $url_s3_poliza = Storage::disk('s3')->putFileAs($filePath, $doc_file, $current, 'public');   
                            $tarjeta->url_file = $url_s3_poliza;
                            $tarjeta->save();
                            Log::channel('vehiculosfiles')->info("Tarjeta en BD guardada");
                        }
                    }
                }
            }
        }
    }

    public function insertarArchivosPoliza($path){
        $dir = opendir($path);
        while ($current = readdir($dir)) {
            if ($current != "." && $current != "..") {
                if (is_file($path . DIRECTORY_SEPARATOR . $current)) {
                
                    $data = explode(".",$current);
                    $ide = str_replace(".pdf","",$data[1]); 

                    Log::channel('vehiculosfiles')->info($ide);
                    Log::channel('vehiculosfiles')->info($current);
                    if(VehiculoGeneral::where('pk_vehicle', $ide)->exists()){
                        $poliza = new Docs();
                        $poliza->fk_vehicle = $ide;
                        $poliza->document_module = 'POLIZA SEGURO';
                        $doc_file = new UploadedFile($path. DIRECTORY_SEPARATOR.$current, $current, 'application/pdf', null, false);
                        $poliza->name_file = $current;
                        $poliza->created_at = Carbon::now();
                        $filePath =  'TMS/Activos/vehiculos/'.$ide.'/PolizaSeguros/'.date("Y").'/Enero';
                        //Valida si este archivo ya fue cargado con anterioridad
                        if(Storage::disk('s3')->exists($filePath."/".$current)){
                            Log::channel('vehiculosfiles')->info("Poliza existente");
                            $url_s3_poliza = Storage::disk('s3')->path($filePath."/".$current);
                        }else{
                            Log::channel('vehiculosfiles')->info("Poliza nueva");
                            $url_s3_poliza = Storage::disk('s3')->putFileAs($filePath, $doc_file, $current, 'public');   
                            $poliza->url_file = $url_s3_poliza;
                            $poliza->save();
                            Log::channel('vehiculosfiles')->info("Poliza en BD guardada");

                            //ALTA EN TABLA HISTORICO POLIZAS DE SEGURO
                        
                            DB::table('historico_polizas_aseguramiento')->insert([
                                'fk_vehicle' => $ide,
                                'fk_user' => 1,
                                'url_file' => $url_s3_poliza,
                                'fecha_transaccion' => $this->timestampUnique,
                            ]);
                            
                            //ALTA EN TABLA HISTORICO POLIZAS DE SEGURO
                        }
                    }
                }
            }
        }
    }
}
