<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class trafilogUnidades extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'trafilog:unidades';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'me trae el ultimo trafilog de cada vehiculo para asignar su ubicación';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $vehicleTraffig = $this->getDataTraffilog();

        //Log::info("LECTURA DE TRAFILOG: ".$vehicleTraffig->count());

        foreach ($vehicleTraffig as $vehicle) {
            Log::info($vehicle);


            Log::info("TIPO DE VALOR: ".gettype($vehicle['license_nmbr']));
            $existe = false;
            try {
                $existe =  DB::table('tms_am_vehicles')->where('pk_vehicle', $vehicle['license_nmbr'])->exists();
            } catch (\Throwable $th) {
                $existe = false;
            }
            $vehicleDB = DB::table('tms_am_vehicle_location_traffilog')->where('fk_vehicle', $vehicle['license_nmbr']);
    
            if ($vehicleDB->exists()) {
                try {
                    $vehicleDB->update([
                        "fk_vehicle" => $vehicle['license_nmbr'],
                        "lat" => $vehicle['latitude'],
                        "lng" => $vehicle['longitude'],
                        "existiendo_activos" => $existe,
                        "fecha_actualizacion" => Carbon::now(),
                    ]);
                    Log::info("vehiculo actualizado");
                } catch (\Throwable $th) {
                    Log::info("no se puede actualizar este vehiculo");
                    throw $th;
                }
            } else {
                try {
                    DB::table('tms_am_vehicle_location_traffilog')->insert([
                        "fk_vehicle" => $vehicle['license_nmbr'],
                        "lat" => $vehicle['latitude'],
                        "lng" => $vehicle['longitude'],
                        "existiendo_activos" => $existe,
                        "fecha_actualizacion" => Carbon::now(),
                    ]);
                    Log::info("vehiculo agregado");
                } catch (\Throwable $th) {
                    Log::info("no se puede agregar este vehiculo");
                    throw $th;
                }
            }
            Log::info("----------------------------------------------------------");
        }
    }

    public function loginTraffilog()
    {

        $params = array("action" => array("name" => "user_login", "parameters" => array("login_name" => "Lidcorpconsulta", "password" => "APIlid2023!")));
        $resp = Http::accept('application/json')
            ->post('https://api-mx.traffilog.com/appengine_3/5E1DCD81-5138-4A35-B271-E33D71FFFFD9/1/json', $params);

        $val = $resp->json();

        Log::info("LOGIN");
        Log::info($val);
        return $val['response']['properties']['data'][0]['session_token'];
    }

    public function getDataTraffilog()
    {

        $params = array("action" => array("name" => "api_get_data", "parameters" => [array("license_nmbr" => "", "version" => "3")], "session_token" => $this->loginTraffilog()));
        $resp = Http::accept('application/json')
            ->post('https://api-mx.traffilog.com/appengine_3/5E1DCD81-5138-4A35-B271-E33D71FFFFD9/1/json', $params);

        $val = $resp->json();

        Log::info("GET DATA");
        //Log::info($val);
        return $val['response']['properties']['data'];
    }
}
