<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;


class HistoricoVehiculo implements FromCollection, WithHeadings
{

    public int $id_vehicle;

    public function __construct($id_vehicle){
        $this->id_vehicle = $id_vehicle;
    }

    public function collection()
    {
        $datos = DB::table('historico_update_vehiculos AS huv')->select('huv.fk_vehicle', 'huv.eco','tms_am_colors.name AS color_name',
        'huv.plates', 'huv.federal_plates', 'huv.fuel_consumption', 'huv.serial_number', 'huv.engine_number',
        'tms_am_entities.name AS entity_company_name', 'tms_am_federal_entities.name AS federal_entity_name',
        'huv.passengers', 'huv.doors', 'tms_am_suspension_types.description AS suspension_type', 
        'tms_am_seat_types.description AS seat_type', 'huv.description', 
        'tms_am_manufacturers.name AS manufacturer_name', 'tms_am_vehicle_models.name AS vehicle_model_name', 
        'tms_am_fuels.name AS fuel_name', 'tms_am_vehicle_models.year AS vehicle_model_year',
        'tms_am_vehicle_usages.name AS usage_name', 'tms_am_vehicle_status.name AS status_vehicle',
        DB::raw("to_date(huv.date_changed::text, 'YYYYMMDD'::text) AS date_c"),
        DB::raw("to_char(to_timestamp(huv.time_changed) at time zone 'utc', 'HH24:MI:SS') AS time_c")
        )
        ->join('tms_am_colors', 'huv.fk_color', 'tms_am_colors.pk_color')
        ->join('tms_am_vehicle_status', 'huv.fk_vehicle_status', 'tms_am_vehicle_status.pk_vehicle_status')
        ->join('tms_am_seat_types', 'huv.fk_seat_type', 'tms_am_seat_types.pk_seat_type')
        ->join('tms_am_suspension_types', 'huv.fk_suspension_type', 'tms_am_suspension_types.pk_suspension_type')
        ->join('tms_am_vehicle_usages', 'huv.fk_vehicle_usage', 'tms_am_vehicle_usages.pk_vehicle_usage')
        ->join('tms_am_vehicle_catalogs', 'huv.fk_vehicle_catalog', 'tms_am_vehicle_catalogs.pk_vehicle_catalog')
        ->join('tms_am_fuels', 'huv.fk_fuel', 'tms_am_fuels.pk_fuel')
        ->join('tms_am_entities', 'huv.fk_entity_company', 'tms_am_entities.pk_entity')
        ->join('tms_am_federal_entities', 'huv.fk_federal_entity', 'tms_am_federal_entities.pk_federal_entity')
        ->join('tms_am_vehicle_models', 'tms_am_vehicle_catalogs.fk_vehicle_model', 'tms_am_vehicle_models.pk_vehicle_model')
        ->join('tms_am_manufacturers', 'tms_am_vehicle_models.fk_manufacturer', 'tms_am_manufacturers.pk_manufacturer')
        ->where('huv.fk_vehicle', $this->id_vehicle)
        ->get();
        return $datos;
    }
    public function headings(): array
    {
        //Put Here Header Name That you want in your excel sheet 
        return [
            'ID SIGO',
            'ECO',
            'COLOR',
            'PLACAS',
            'PLACAS FEDERALES',
            'CONSUMO DEL VEHICULO',
            'NO.SERIE',
            'NO.MOTOR',
            'UN',
            'ENTIDAD FEDERATIVA',
            'ASIENTOS',
            'PUERTAS',
            'TIPO DE SUSPENSION',
            'TIPO DE ASIENTOS',
            'DESCRIPCION',
            'MARCA',
            'MODELO',
            'COMBUSTIBLE',
            'AÑO DEL MODELO',
            'STATUS OPERATIVO',
            'STATUS',
            'FECHA',
            'HORA'
        ];
    }

}
