<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Adquisicion;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class AdquisicionController extends Controller
{
    var $timestampUnique = 0;
    public function __construct()
    {
        //Los registros tengan la misma fecha y hora exacta
        $this->timestampUnique = Carbon::now('GMT-6');
    }

    public function store(Request $request){
        $request->validate([
            'monto_depreciacion' => 'required',
            'fecha_depreciacion' => 'required',
            'observaciones_depreciacion' => 'required'
        ]);

        DB::transaction(function() use($request) {

            $depreciacion = new Adquisicion();
            $depreciacion->fk_vehicle = $request->fk_vehicle;
            $depreciacion->depreciation_mount = $request->monto_depreciacion;
            $depreciacion->depreciation_date = $request->fecha_depreciacion;
            $depreciacion->depreciation_observations = $request->observaciones_depreciacion;
            $depreciacion->save();

            //ALTA EN TABLA HISTORICO DEPRECIACION ACTIVOS
            DB::table('historico_depreciacion_activos')->insert([
                'fk_dep_asset' => $depreciacion->pk_dep_asset,
                'fk_vehicle' => $request->fk_vehicle,
                'fk_user' => $request->id_usuario,
                'monto_depreciacion' => $request->monto_depreciacion,
                'fecha_depreciacion' => $request->fecha_depreciacion,
                'observaciones_depreciacion' => $request->observaciones_depreciacion,
                'fecha_transaccion' => $this->timestampUnique,
            ]);
            //ALTA EN TABLA HISTORICO DEPRECIACION ACTIVOS
        });

        return response("success", 200);
    }

    public function update(Request $request, $id){
        $request->validate([
            'monto_depreciacion' => 'required',
            'fecha_depreciacion' => 'required',
            'observaciones_depreciacion' => 'required'
        ]);

        DB::transaction(function() use($request, $id) {

            $updateDepreciacion = Adquisicion::where('pk_dep_asset', $id)->update([
                'depreciation_mount' => $request->monto_depreciacion,
                'depreciation_date' => $request->fecha_depreciacion,
                'depreciation_observations' => $request->observaciones_depreciacion,                
            ]);

            //ALTA EN TABLA HISTORICO DEPRECIACION ACTIVOS
            DB::table('historico_depreciacion_activos')->insert([
                'fk_dep_asset' => $id,
                'fk_vehicle' => $request->fk_vehicle,
                'fk_user' => $request->id_usuario,
                'monto_depreciacion' => $request->monto_depreciacion,
                'fecha_depreciacion' => $request->fecha_depreciacion,
                'observaciones_depreciacion' => $request->observaciones_depreciacion,
                'fecha_transaccion' => $this->timestampUnique,
            ]);
            //ALTA EN TABLA HISTORICO DEPRECIACION ACTIVOS
        });

        return response("success", 200);
    }

    public function findByVehicle($id){
        $DepreciacionInfo = Adquisicion::where('fk_vehicle', $id)->get();
        return response($DepreciacionInfo, 200);
    }
}
