<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Repositories\TMSGlobal;
use Hamcrest\Core\HasToString;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CascadeoController extends Controller
{
    protected $conexion; 

    public function __construct(TMSGlobal $tms_global) {
        $this->conexion = $tms_global;

    }


    public function getHistoryVehicle($id){
        $coincidencias = DB::table('historico_update_vehiculos AS huv')
        ->select('tms_am_entities.name AS entity_company_name',
        DB::raw("MAX(to_date(date_changed::text, 'YYYYMMDD'::text)||', '||to_char(to_timestamp(time_changed) at time zone 'utc', 'HH24:MI:SS')||', '||fk_user)AS fecha_hora_id_usuario"))
        ->join('tms_am_entities', 'huv.fk_entity_company', 'tms_am_entities.pk_entity')
        ->where('fk_vehicle', $id)
        ->groupBy('entity_company_name')
        ->orderBy('fecha_hora_id_usuario', 'DESC')->get();

        foreach($coincidencias as $elemento){
            $var = explode(",", $elemento->fecha_hora_id_usuario);
            $var[2] = $this->conexion->findUser($var[2]);
            $elemento->fecha_hora_id_usuario = $var;
        }
        return response()->json([
            "data" => $coincidencias
        ]);
    }   
}
/* to_date(ft.fuel_ticket_date::text, 'YYYYMMDD'::text) AS fuel_ticket_date */