<?php

namespace App\Http\Controllers\API;


use App\Http\Controllers\Controller;
use App\Models\Color;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ColorsController extends Controller
{
    public function index()
    {
            $colores = Color::where('status', true)->get();
            return response()->json([
                "data" => $colores
            ]);
    }

    public function store(Request $request)
    {

        $color = new Color();
        $color->pk_color = DB::raw("nextval('secuencia_colores')");
        $color->name = $request->name;
        $color->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $color = Color::findOrFail($id);
        return response($color, 200);
    }

    public function update(Request $request, $id)
    {
        $updateColor = Color::where('pk_color', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        $updateColor = Color::where('pk_color', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
