<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Complemento;
use App\Models\VehiculoGeneral;
use Illuminate\Http\Request;

class ComplementoController extends Controller
{
    public function index(){
        $complementos = Complemento::where('status', true)->get();
        return response()->json([
            "data" => $complementos
        ]);
    }

    public function update(Request $request, $id){
        $vehiculo = VehiculoGeneral::findOrFail($id);
        $vehiculo->complements()->sync($request->get('complements'));
        return response('success', 200);
    }
}
