<?php

namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Models\Fuel;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use Illuminate\Pagination\LengthAwarePaginator;
use DateTime;

class FuelTicketsController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function fuel(Request $request){


        $limit = intval($request->query('limit', 1000));
        return Fuel::paginate($limit);



    }


    public function fuelInsert(Request $request){

    $data = json_decode($request->getContent());

   // date_default_timezone_set('Etc/UTC');
   date_default_timezone_set("America/Mexico_City");
     
    
 

    $fecha1=trim($data->ticket_date);
    $fecha1=str_replace ( "/", '-', $fecha1);

    $fecha = new DateTime($fecha1);
    $fechaIntTicket = $fecha->format('Ymd');

    $fecha2=trim($data->registry_date);
    $fecha2=str_replace ( "/", '-', $fecha2);

    $fechaRe = new DateTime($fecha2);
    $fechaIntfecharegistry_date= $fechaRe->format('Ymd');


    //consultamos el id del usuario
     $id=$data->fk_user;

     $nameSigisql=DB::select("SELECT * FROM users WHERE name='$id'");

     if(count($nameSigisql)>0){

        $nameSigo=$nameSigisql[0]->pk_user;
     }else{
     
        $nameSigo=1954; //usuario interno de no encontrado
     }

    $insert= DB::table('fuel_tickets')->insert(
            [
            "fk_vehicle"=>$data->vehicle_id,
            "fk_fuel"=>$data->fuel_id,
            "dispatched_fuel"=>$data->dispatched_fuel,
            "odometer"=>$data->odometer,
            "fuel_ticket_date"=>$fechaIntTicket,
            "registry_date"=>date("Ymd"),//$fechaIntfecharegistry_date,
            "fk_old_fuel_cost"=>null,//$datos['old_cost_id'],
            "ticket_number"=>$data->ticket_number,
            "fuel_consumption"=>$data->fuel_consumption,
            "distance"=>$data->distance,
            "fk_entity_fuel_provider"=>$data->provider_id,
         
            "cost"=>$data->cost,
            "ieps"=>$data->ieps,
            "tax"=>$data->tax,
            "base_cost"=>$data->base_cost,
            
            "fk_fuel_cost"=>$data->fuel_cost_id,
            "fk_user"=>$nameSigo,
            "fk_entity_company"=>$data->fk_entity_company,
            "historic_time"=>date("His"),
            "historic_date"=>date("Ymd"),
            "historic_user"=>$nameSigo

             ]);

             //actualizamos el odometro en vehículos

             $idV=$data->vehicle_id;
             
             DB::table('vehicles')->where('pk_vehicle', $idV)->update( 
                array('last_odometer_fuel_ticket' =>$data->odometer));

            //actualizamos el usuario que modifica

            $vehicles_history=DB::select("SELECT  pk_vehicle_history from vehicle_history vh where vehicle_id =$idV order by pk_vehicle_history desc limit 1");

                if(count($vehicles_history)){

                             //actualizamos el histórico en relación al usuario
                $id_hist=$vehicles_history[0]->pk_vehicle_history;

                DB::table('vehicle_history')->where('pk_vehicle_history', $id_hist)->update(array('fk_user' =>$nameSigo));

                }


            

        return "con éxito";


    }

    public function extraeDatos($valor){

        $extrae=explode('=>',$valor);

        return $extrae[1];

    }

  

  
        

   


   
}
