<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Gasolina;
use Illuminate\Http\Request;

class GasolinaController extends Controller
{
    public function index()
    {
        $combustibles = Gasolina::where('status', true)->get();
        return response()->json([
            "data" => $combustibles
        ]);    
    }

    public function store(Request $request)
    {
        $gasolina = new Gasolina();
        $gasolina->name = $request->name;
        $gasolina->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $combustible = Gasolina::findOrFail($id);
        return response($combustible, 200);
    }

    public function update(Request $request, $id)
    {
        $updateGasolina = Gasolina::where('pk_fuel', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //Gasolina::findOrFail($id)->delete();
        $updateGasolina = Gasolina::where('pk_fuel', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
