<?php

namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use App\Models\GPS;
use App\Models\proveedor_GPS;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use Illuminate\Pagination\LengthAwarePaginator;

class GpsProvidersController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function gpsproviders(Request $request){




        $limit = intval($request->query('limit', 1000));
        return  GPS::paginate($limit);



    }


    public function index()
    {
            $proveedores = proveedor_GPS::where('status', true)->get();
            return response()->json([
                "data" => $proveedores
            ]); 
    }

    public function store(Request $request)
    {
        $proveedor = new proveedor_GPS();
        $proveedor->name = $request->name;
        $proveedor->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $proveedor = proveedor_GPS::findOrFail($id);
        return response($proveedor, 200);
    }

    public function update(Request $request, $id)
    {
        $updateProveedor = proveedor_GPS::where('pk_gps_provider', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //proveedor_GPS::findOrFail($id)->delete();
        $updateProveedor = proveedor_GPS::where('pk_gps_provider', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }

  
        

   


   
}
