<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Imagen;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class ImagenesController extends Controller
{
    var $timestampUnique = 0;
    var $meses = [];
    public function __construct()
    {
        //Los registros tengan la misma fecha y hora exacta
        $this->timestampUnique = Carbon::now('GMT-6');
        $this->meses    = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
    }

    public function storeImages(Request $request){
        if($request->has('imageVehicle')){
            $imagenes = $request->file('imageVehicle');
            foreach($imagenes as $file){
                $imagen = new Imagen();
                $imagen->fk_vehicle = $request->fk_vehicle;
                $doc_file = $file;
                $imagen->name_file = $file->getClientOriginalName();
                $filePath = env('FOLDER_DIRECTIVE_AWS').'/Activos/vehiculos/'.$request->fk_vehicle.'/images/initial/'.date("Y").'/'.$this->meses[date('m') - 1];
                $url_s3 = Storage::disk('s3')->put($filePath, $doc_file, 'public');
                $imagen->actual_image = false;
                $imagen->upload_date = now();
                $imagen->url_image = $url_s3;
                $imagen->save();
            }
            return response($imagenes, 200);
        }else{
            return response("error", 404);
        }
    }

    public function storeImagesActually(Request $request){
        if($request->typeAction == "Edit"){
            DB::transaction(function() use($request) {
                $id = $request->fk_vehicle;
                $imagenesExistentes = Imagen::where('fk_vehicle', $id)->where('actual_image', true)->get();
                if($imagenesExistentes){
                    Imagen::where('fk_vehicle', $id)->where('actual_image', true)->update([
                        'status' => false,
                    ]);
                }
                
                if($request->has('imageVehicle')){
                    $imagenes = $request->file('imageVehicle');
                    foreach($imagenes as $file){
                        $imagen = new Imagen();
                        $imagen->fk_vehicle = $id;
                        $doc_file = $file;
                        $imagen->name_file = $file->getClientOriginalName();
                        $filePath = env('FOLDER_DIRECTIVE_AWS').'/Activos/vehiculos/'.$id.'/images/actually/'.date("Y").'/'.$this->meses[date('m') - 1];
                        $url_s3 = Storage::disk('s3')->put($filePath, $doc_file, 'public');
                        $imagen->actual_image = true;
                        $imagen->upload_date = now();
                        $imagen->url_image = $url_s3;
                        $imagen->save();

                        //ALTA EN TABLA HISTORICO DE IMAGENES ACTUALES
                        DB::table('historico_imagenes_actuales')->insert([
                            'fk_vehicle' => $request->fk_vehicle,
                            'fk_user' => $request->id_usuario,
                            'url_file' => $url_s3,
                            'fecha_transaccion' => $this->timestampUnique,
                        ]);
                        //ALTA EN TABLA HISTORICO DE IMAGENES ACTUALES
                    }
                    return response($imagenes, 200);
                }else{
                    return response("No tiene imagenes", 404);
                }
                });
        }else if($request->typeAction == "Create"){
            if($request->has('imageVehicle')){
                $imagenes = $request->file('imageVehicle');
                foreach($imagenes as $file){
                    $imagen = new Imagen();
                    $imagen->fk_vehicle = $request->fk_vehicle;
                    $doc_file = $file;
                    $imagen->name_file = $file->getClientOriginalName();
                    $filePath = env('FOLDER_DIRECTIVE_AWS').'/Activos/vehiculos/'.$request->fk_vehicle.'/images/actually/'.date("Y").'/'.$this->meses[date('m') - 1];
                    $url_s3 = Storage::disk('s3')->put($filePath, $doc_file, 'public');
                    $imagen->actual_image = true;
                    $imagen->upload_date = now();
                    $imagen->url_image = $url_s3;
                    $imagen->save();

                    //ALTA EN TABLA HISTORICO DE IMAGENES ACTUALES
                    DB::table('historico_imagenes_actuales')->insert([
                        'fk_vehicle' => $request->fk_vehicle,
                        'fk_user' => $request->id_usuario,
                        'url_file' => $url_s3,
                        'fecha_transaccion' => $this->timestampUnique,
                    ]);
                    //ALTA EN TABLA HISTORICO DE IMAGENES ACTUALES
                }
                return response($imagenes, 200);
            }else{
                return response("error", 404);
            }
        }
    }
}
