<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Marca;
use Illuminate\Http\Request;

class MarcasController extends Controller
{
    public function index()
    {
            $marcas = Marca::where('status', true)->orderBy('name', 'ASC')->get();
            return response()->json([
                "data" => $marcas
            ]); 
    }

    public function store(Request $request)
    {
        $marca = new Marca();
        $marca->name = $request->name;
        $marca->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $marca = Marca::findOrFail($id);
        return response($marca, 200);
    }

    public function update(Request $request, $id)
    {
        $updateMarca = Marca::where('pk_manufacturer', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //Marca::findOrFail($id)->delete();
        $updateMarca = Marca::where('pk_manufacturer', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
