<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Menu;
use Carbon\Carbon;
use Illuminate\Http\Request;

class MenuController extends Controller
{
    public function index(){
        $menus = Menu::where('activo', true)->get();
        return response($menus, 200);
    }

    public function store(Request $request){
        $menu = new Menu();
        $menu->id_padre = $request->id_padre;
        $menu->titulo = $request->titulo;
        $menu->url = $request->url;
        $menu->icono = $request->icono;
        $menu->class = $request->clase;
        $menu->orden = $request->orden;
        $menu->fecha_registro = Carbon::now();
        $menu->fecha_actualizacion = null;
        $menu->fecha_baja = null;
        $menu->save();

        return response('success', 200);
    }

    public function show($id){
        $menu = Menu::findOrFail($id);
        return response()->json([
            "data" => $menu
        ]); 
    }

    public function update(Request $request, $id)
    {
        $updateMenu = Menu::where('id_menu', $id)->update([
            'id_padre' => $request->edit_id_padre,
            'titulo' => $request->edit_titulo,
            'url' => $request->edit_url,
            'icono' => $request->edit_icono,
            'class' => $request->edit_clas,
            'orden' => $request->edit_orden
        ]);

        return response('success', 200);
    }

    public function destroy(int $id)
    {
        $this->loop_destroy($id);
        $result = ['status' => true, 'error' => null];
        return $result;

    }

    public function loop_destroy($id_menu)
    {
        $menus = Menu::findOrFail($id_menu);
        $menus->activo = 0;
        $menus->fecha_baja = Carbon::now();
        $menus->update();
        $menus = Menu::where('id_padre', $id_menu)->get();
        if (count($menus) > 0) {
            foreach ($menus as $item) {
                $this->loop_destroy($item->id_menu);
            }
        }
    }
}
