<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\TipoAsiento;
use Illuminate\Http\Request;

class TiposAsientoController extends Controller
{
    public function index()
    {
            $tipos_asiento = TipoAsiento::where('status', true)->get();
            return response()->json([
                "data" => $tipos_asiento
            ]); 
    }

    public function store(Request $request)
    {
        $request->validate([
            'description' => 'required'
        ]);
        
        $tipo_asiento = new TipoAsiento();
        $tipo_asiento->description = $request->description;
        $tipo_asiento->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $tipo_asiento = TipoAsiento::findOrFail($id);
        return response($tipo_asiento, 200);
    }

    public function update(Request $request, $id)
    {
        $updateTipoAsiento = TipoAsiento::where('pk_seat_type', $id)->update([
            'description' => $request->edit_description
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //TipoAsiento::findOrFail($id)->delete();
        $updateTipoAsiento = TipoAsiento::where('pk_seat_type', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
