<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\TipoSuspension;
use Illuminate\Http\Request;

class TiposSupensionController extends Controller
{
    public function index()
    {
            $tipos_suspension = TipoSuspension::where('status', true)->get();
            return response()->json([
                "data" => $tipos_suspension
            ]); 
    }

    public function store(Request $request)
    {
        $tipo_suspension = new TipoSuspension();
        $tipo_suspension->description = $request->description;
        $tipo_suspension->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $tipo_suspension = TipoSuspension::findOrFail($id);
        return response($tipo_suspension, 200);
    }

    public function update(Request $request, $id)
    {
        $updateTipoSuspension = TipoSuspension::where('pk_suspension_type', $id)->update([
            'description' => $request->edit_description
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //TipoSuspension::findOrFail($id)->delete();
        $updateTipoSuspension = TipoSuspension::where('pk_suspension_type', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
