<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculosCatalogo;
use Illuminate\Http\Request;

class VehiculosCatalogoController extends Controller
{
    public function index()
    {
            $catalogo = VehiculosCatalogo::select('tms_am_vehicle_catalogs.*', 'tms_am_vehicle_types.name AS vehicle_type_name',
            'tms_am_manufacturers.name AS manufacturer_name', 'tms_am_vehicle_models.name AS vehicle_model_name', 'tms_am_vehicle_models.year AS vehicle_model_year')
            ->join('tms_am_vehicle_types', 'tms_am_vehicle_catalogs.fk_vehicle_type', 'tms_am_vehicle_types.pk_vehicle_type')
            ->join('tms_am_vehicle_models', 'tms_am_vehicle_catalogs.fk_vehicle_model', 'tms_am_vehicle_models.pk_vehicle_model')
            ->join('tms_am_manufacturers', 'tms_am_vehicle_models.fk_manufacturer', 'tms_am_manufacturers.pk_manufacturer')
            ->where('tms_am_vehicle_catalogs.status', true)
            ->get();

            return response()->json([
                "data" => $catalogo
            ]); 
    }

    public function store(Request $request)
    {
        $ultimo_registro = VehiculosCatalogo::orderBy('pk_vehicle_catalog', 'desc')->first();
        $catalogo = new VehiculosCatalogo();
        if($ultimo_registro == null){
            $catalogo->pk_vehicle_catalog = 1;
        }else{
            $catalogo->pk_vehicle_catalog = $ultimo_registro->pk_vehicle_catalog+1;
        }
        $catalogo->fk_vehicle_type = $request->tipo_vehiculo;
        $catalogo->version = $request->version;
        $catalogo->fuel_consumption_avg = $request->consumo;
        $catalogo->fuel_capacity = $request->capacidad_combustible;
        $catalogo->tax = $request->impuesto;
        $catalogo->environment_tax = $request->impuesto_ambiental;
        $catalogo->fk_vehicle_model = $request->modelo;
        $catalogo->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $catalogo = VehiculosCatalogo::findOrFail($id);
        return response($catalogo, 200);
    }

    public function update(Request $request, $id)
    {
        $updateCatalogo = VehiculosCatalogo::where('pk_vehicle_catalog', $id)->update([
            'fk_vehicle_type' => $request->edit_tipo_vehiculo,
            'version' => $request->edit_version,
            'fuel_consumption_avg' => $request->edit_consumo,
            'fuel_capacity' => $request->edit_capacidad_combustible,
            'tax' => $request->edit_impuesto,
            'environment_tax' => $request->edit_impuesto_ambiental,
            'fk_vehicle_model' => $request->edit_modelo,
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculosCatalogo::findOrFail($id)->delete();
        $updateCatalogo = VehiculosCatalogo::where('pk_vehicle_catalog', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }

    public function findResults(Request $request){
        $data = VehiculosCatalogo::select('tms_am_vehicle_catalogs.*', 'tms_am_vehicle_types.name AS vehicle_type_name',
            'tms_am_manufacturers.name AS manufacturer_name', 'tms_am_vehicle_models.name AS vehicle_model_name', 'tms_am_vehicle_models.year AS vehicle_model_year')
            ->join('tms_am_vehicle_types', 'tms_am_vehicle_catalogs.fk_vehicle_type', 'tms_am_vehicle_types.pk_vehicle_type')
            ->join('tms_am_vehicle_models', 'tms_am_vehicle_catalogs.fk_vehicle_model', 'tms_am_vehicle_models.pk_vehicle_model')
            ->join('tms_am_manufacturers', 'tms_am_vehicle_models.fk_manufacturer', 'tms_am_manufacturers.pk_manufacturer')
            ->where('tms_am_vehicle_catalogs.version', 'like', '%'.$request->search.'%')
            ->orWhere('tms_am_vehicle_models.name', 'like', '%'.$request->search.'%')
            ->orWhere('tms_am_vehicle_models.year', 'like', '%'.$request->search.'%')
            ->orWhere('tms_am_manufacturers.name', 'like', '%'.$request->search.'%')
            ->where('tms_am_vehicle_catalogs.status', true)
            ->get();

            return $data;
    }
}
