<?php

namespace App\Http\Controllers\API;
use App\Http\Controllers\Controller;
use App\Models\VehiculosEstatus;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Pagination\Paginator;
use Illuminate\Pagination\LengthAwarePaginator;

class VehiculosEstatusController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
       // $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */


    public function vehiculosEstatus(Request $request){




        $limit = intval($request->query('limit', 1000));
        return   VehiculosEstatus::paginate($limit);



    }

    public function index()
    {
            $status = VehiculosEstatus::where('status', true)->get();
            return response()->json([
                "data" => $status
            ]); 
    }

    public function store(Request $request)
    {
        $status = new VehiculosEstatus();
        $status->name = $request->name;
        $status->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $status = VehiculosEstatus::findOrFail($id);
        return response($status, 200);
    }

    public function update(Request $request, $id)
    {
        $updateStatus = VehiculosEstatus::where('pk_vehicle_status', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculosEstatus::findOrFail($id)->delete();
        $updateStatus = VehiculosEstatus::where('pk_vehicle_status', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
