<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculosEstatusGrupo;
use Illuminate\Http\Request;

class VehiculosEstatusGrupoController extends Controller
{
    public function index()
    {
            $status = VehiculosEstatusGrupo::where('status', true)->get();
            return response()->json([
                "data" => $status
            ]); 
    }

    public function store(Request $request)
    {
        $status = new VehiculosEstatusGrupo();
        $status->name = $request->name;
        $status->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $status = VehiculosEstatusGrupo::findOrFail($id);
        return response($status, 200);
    }

    public function update(Request $request, $id)
    {
        $updateStatus = VehiculosEstatusGrupo::where('pk_vehicle_status_group', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculosEstatusGrupo::findOrFail($id)->delete();
        $updateStatus = VehiculosEstatusGrupo::where('pk_vehicle_status_group', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
