<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculosFlota;
use Illuminate\Http\Request;

class VehiculosFlotaController extends Controller
{
    public function index()
    {
            $flotas = VehiculosFlota::where('status', true)->get();
            return response()->json([
                "data" => $flotas
            ]); 
    }

    public function store(Request $request)
    {
        $flota = new VehiculosFlota();
        $flota->name = $request->name;
        $flota->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $flota = VehiculosFlota::findOrFail($id);
        return response($flota, 200);
    }

    public function update(Request $request, $id)
    {
        $updateFlota = VehiculosFlota::where('pk_vehicle_fleet', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculosFlota::findOrFail($id)->delete();
        $updateFlota = VehiculosFlota::where('pk_vehicle_fleet', $id)->update([
            'name' => false
        ]);
        return response('success', 200);
    }
}
