<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculoModelo;
use Illuminate\Http\Request;

class VehiculosModeloController extends Controller
{
    public function index()
    {
            $modelos = VehiculoModelo::select('tms_am_vehicle_models.*', 'tms_am_manufacturers.name AS manufacturer_name')
            ->join('tms_am_manufacturers', 'tms_am_vehicle_models.fk_manufacturer', 'tms_am_manufacturers.pk_manufacturer')
            ->where('tms_am_vehicle_models.status', true)
            ->get();
            return response()->json([
                "data" => $modelos
            ]); 
    }

    public function store(Request $request)
    {
        $modelo = new VehiculoModelo();
        $modelo->name = $request->name;
        $modelo->year = $request->year;
        $modelo->fk_manufacturer = $request->marca;
        $modelo->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $modelo = VehiculoModelo::select('tms_am_vehicle_models.*', 'tms_am_manufacturers.name AS manufacturer_name')
        ->join('tms_am_manufacturers', 'tms_am_vehicle_models.fk_manufacturer', 'tms_am_manufacturers.pk_manufacturer')
        ->where('tms_am_vehicle_models.pk_vehicle_model', $id)->get();
        return response($modelo, 200);
    }

    public function update(Request $request, $id)
    {
        $updateModelo = VehiculoModelo::where('pk_vehicle_model', $id)->update([
            'name' => $request->edit_name,
            'year' => $request->edit_year,
            'fk_manufacturer' => $request->edit_marca,
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculoModelo::findOrFail($id)->delete();
        $updateModelo = VehiculoModelo::where('pk_vehicle_model', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
