<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculoOrigen;
use Illuminate\Http\Request;

class VehiculosOrigenController extends Controller
{
    public function index()
    {
            $origenes = VehiculoOrigen::where('status', true)->get();
            return response()->json([
                "data" => $origenes
            ]); 
    }

    public function store(Request $request)
    {
        $origen = new VehiculoOrigen();
        $origen->name = $request->name;
        $origen->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $origen = VehiculoOrigen::findOrFail($id);
        return response($origen, 200);
    }

    public function update(Request $request, $id)
    {
        $updateOrigen = VehiculoOrigen::where('pk_vehicle_origin', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculoOrigen::findOrFail($id)->delete();
        $updateOrigen = VehiculoOrigen::where('pk_vehicle_origin', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
