<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\VehiculosTipo;
use Illuminate\Http\Request;

class VehiculosTipoController extends Controller
{
    public function index()
    {
            $status = VehiculosTipo::where('status', true)->get();
            return response()->json([
                "data" => $status
            ]); 
    }

    public function store(Request $request)
    {
        $status = new VehiculosTipo();
        $status->name = $request->name;
        $status->save();

        return response('success', 200);
    }

    public function show($id)
    {
        $status = VehiculosTipo::findOrFail($id);
        return response($status, 200);
    }

    public function update(Request $request, $id)
    {
        $updateStatus = VehiculosTipo::where('pk_vehicle_type', $id)->update([
            'name' => $request->edit_name
        ]);

        return response('success', 200);
    }

    public function destroy($id)
    {
        //VehiculosTipo::findOrFail($id)->delete();
        $updateStatus = VehiculosTipo::where('pk_vehicle_type', $id)->update([
            'status' => false
        ]);
        return response('success', 200);
    }
}
