<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Docs;
use App\Models\Imagen;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class ZipFileController extends Controller
{
    var $headersTypeCont = [];

    public function __construct()
    {
        $this->headersTypeCont = [ 'application/pdf', 'application/png' ];
    }

    //Dev
    public function download(Request $request){
        $ide_vehicle = $request->id_vehicle;

        try {
            //borrar archivo para evitar duplicidad
        if(file_exists(base_path()."/public/zipDocs.zip")){
            Log::info("Se borro el ultimo archivo zip guardado ".$ide_vehicle);
            unlink(base_path()."/public/zipDocs.zip");
        }

            if(count($request->IdesDocs) > 0 || count($request->IdesImages) > 0){
                $zip = new ZipArchive();
                $path_folder= base_path()."/public";
                $zip->open($path_folder.'/zipDocs.zip', ZipArchive::CREATE);

                for ($i=0; $i < count($request->IdesDocs); $i++) {
                    Log::info("Obteniendo archivo de doc de BD ".$ide_vehicle); 
                    $documento = Docs::find($request->IdesDocs[$i]);
                    Log::info("Obteniendo archivo de doc de S3 ".$ide_vehicle); 
                    $s3_file = Storage::disk('s3')->get($documento->url_file);
                    $zip -> addFromString($documento->name_file,$s3_file); 

                    //Storage::disk('s3')->url($documento->url_file);
                }
                for ($i=0; $i < count($request->IdesImages); $i++) { 
                    Log::info("Obteniendo archivo de image de BD ".$ide_vehicle); 
                    $imagenes = Imagen::find($request->IdesImages[$i]);
                    Log::info("Obteniendo archivo de image de S3 ".$ide_vehicle); 
                    $s3_image = Storage::disk('s3')->get($imagenes->url_image);
                    $zip -> addFromString($imagenes->name_file,$s3_image); 
                    //Storage::disk('s3')->url($imagenes->url_file);
                }

                $zip->close();

            }

        $filetopath= base_path().'/public/zipDocs.zip';
        if(file_exists($filetopath)){
            //local
            //return "http://localhost/api_tms_mov_act/public/zipDocs.zip";
            //prod
            Log::info("Archivo generado");
            return env("APP_DEV")."/api_tms_mov_activos/public/zipDocs.zip";
            /* return response()->download($filetopath,
            "zipDocs.zip",
            array('Content-Type: application/octet-stream', 'Content-Length: '.filesize($filetopath)))
            ->deleteFileAfterSend(true); */
        }else{
            Log::info("La ruta ".$filetopath." no se encontro");
            return response("No se encuentra el archivo",404);
        }
        } catch (\Throwable $th) {
            Log::info("No se genero el zip de archivos para el vehiculo ".$ide_vehicle);
            //$this->borrar_archivos_temp(base_path()."/public/storage/temp/".$ide_vehicle);
            return response("No se genero el archivo",400);
        }
        
    }

    /* public function borrar_archivos_temp($dirname) {
        //si es un directorio lo abro
             if (is_dir($dirname))
               $dir_handle = opendir($dirname);
            //si no es un directorio devuelvo false para avisar de que ha habido un error
         if (!$dir_handle)
              return false;
            //recorro el contenido del directorio fichero a fichero
         while($file = readdir($dir_handle)) {
               if ($file != "." && $file != "..") {
                       //si no es un directorio elemino el fichero con unlink()
                    if (!is_dir($dirname."/".$file))
                         unlink($dirname."/".$file);
                    else //si es un directorio hago la llamada recursiva con el nombre del directorio
                    $this->borrar_archivos_temp($dirname.'/'.$file);
               }
         }
         closedir($dir_handle);
        //elimino el directorio que ya he vaciado
         rmdir($dirname);
         return true;
    } */
}
