<?php

namespace App\Http\Requests\Costos;

use Illuminate\Foundation\Http\FormRequest;

class StoreCostos extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_tipo_costo' => ['required', 'int'],
            'id_marca_plaza' => ['required', 'int'],
            'costo' => ['required', 'numeric', 'regex:/^\d+(\.\d{1,2})?$/'],
            'descripcion' => ['required', 'string', 'max:150'],
        ];
    }
}
