<?php

namespace App\Http\Requests\Cotizaciones;

use Illuminate\Foundation\Http\FormRequest;

class StoreCotizaciones extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_tipo_cotizacion' => ['required', 'int'],
            'id_canal' => ['required','int'],
            'id_estatus_cotizacion' => ['required','int'],
            'id_marca_plaza' => ['required','int'],
            'nombre1_contacto' => ['required','string', 'max:200'],
            'nombre2_contacto' => ['string', 'max:200'],
            'email' => ['required','string','email'],
            'celular' => ['required','string','size:10'],
            'nombre_cotizacion' => ['required','string', 'max:150'],
            'precio' => ['required','numeric','regex:/^\d+(\.\d{1,2})?$/'],
            'iva' => ['required','numeric','regex:/^\d+(\.\d{1,2})?$/'],
            'precio_total' => ['required','numeric','regex:/^\d+(\.\d{1,2})?$/'],
        ];
    }
}
