<?php

namespace App\Http\Requests\Cotizaciones;

use Illuminate\Foundation\Http\FormRequest;

class UpdateCotizaciones extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_tipo_cotiza' => [ 'int'],
            'id_canal' => ['int'],
            'id_estatus_cotizacion' => ['int'],
            'id_marca_plaza' => ['int'],
            'nombre1_contacto' => ['string', 'max:200'],
            'nombre2_contacto' => ['string', 'max:200'],
            'email' => ['string','email', 'max:255'],
            'celular' => ['string','size:10'],
            'nombre_cotizacion' => ['string', 'max:150'],
            'precio' => ['numeric','regex:/^\d+(\.\d{1,2})?$/'],
            'iva' => ['numeric','regex:/^\d+(\.\d{1,2})?$/'],
            'precio_total' => ['numeric','regex:/^\d+(\.\d{1,2})?$/']
        ];
    }
}
