<?php

namespace App\Http\Requests\DetalleCotizaciones;

use Illuminate\Foundation\Http\FormRequest;

class StoreDetalleCotizaciones extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_cotizacion' => ['required', 'int'],
            'id_lugar_destino' => ['required', 'int'],
            'id_lugar_regreso' => ['required', 'int'],
            'id_lugar_salida' => ['required', 'int'],
            'total_personas' => ['required', 'int'],
            'fecha_salida' => ['required','before_or_equal:fecha_regreso', 'date'],
            'fecha_regreso' => ['required','after_or_equal::fecha_salida', 'date'],
            'hora_salida' => ['required', 'date_format:H:i:s'],
            'hora_regreso' => ['required', 'date_format:H:i:s'],
            //'hora_regreso' => ['required', 'date_format:H:i'],
            'kms' => ['required', 'int'],
            'nom_casetas' => ['required', 'int'],
            'total_casetas' => ['required', 'int'],
        ];
    }

    public function messages()
    {

        return [
            'id_lugar_destino.required' => 'Please, fill in the initial time',
        ];

    }
}
