<?php

namespace App\Http\Requests\DetalleCotizaciones;

use Illuminate\Foundation\Http\FormRequest;

class UpdateDetalleCotizaciones extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_cotizacion' => ['int'],
            'id_lugar_destino' => ['int'],
            'id_lugar_regreso' => ['int'],
            'id_lugar_salida' => ['int'],
            'total_personas' => ['int'],
            'fecha_salida' => ['before_or_equal:fecha_regreso', 'date'],
            'fecha_regreso' => ['after_or_equal::fecha_salida', 'date'],
            'hora_salida' => ['date_format:H:i:s'],
            'hora_regreso' => ['date_format:H:i:s'],
            'kms' => ['int'],
            'nom_casetas' => ['int'],
            'total_casetas' => ['int'],
        ];
    }
}
