<?php

namespace App\Http\Requests\MarcasPlazas;

use Illuminate\Foundation\Http\FormRequest;
use  Illuminate\Validation\Rule;
//use App\Rules\Rules;

class StoreMarcasPlazas extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_marca' => ['required', 'int',
                Rule::unique('marcas_plazas')->where('id_marca', $this->id_marca)
                    ->where('id_plaza', $this->id_plaza)
                    ->where('id_rubro', $this->id_rubro)
                    ->where('id_region', $this->id_region)
            ],
            'id_plaza' => ['required', 'int'],
            'id_rubro' => ['required', 'int'],
            'id_region' => ['required', 'int'],
            'id_sigo' => ['required', 'int'],
            'descripcion_larga' => ['required', 'string', 'max:255'],
            'descripcion_corta' => ['required', 'string', 'max:150'],
        ];
    }
}
