<?php

namespace App\Http\Requests\Usuarios;

use Illuminate\Foundation\Http\FormRequest;

class StoreUsuarios extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_marca_plaza' => ['required', 'int'],
            'id_usuario_estatus' => ['required','int'],
            'email' => ['required','string','unique:usuarios', 'max:150'],
            'nombre' => ['required','string', 'max:150'],
            'usuario' => ['required','string','unique:usuarios', 'max:150'],
            'password' => ['required','string', 'max:255'],
            'email_verified_at' => ['required','date'],
            'remember_token' => ['string', 'max:225'],
        ];
    }
}
