<?php

namespace App\Http\Requests\Usuarios;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUsuarios extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'id_marca_plaza' => ['int'],
            'id_usuario_estatus' => ['int'],
            'nombre' => ['string', 'max:150'],
            'email' => ['string', 'max:150'],
            'usuario' => ['string', 'max:150'],
            'password' => ['string', 'max:255'],
            'email_verified_at' => ['date'],
            'remember_token' => ['string', 'max:225'],
        ];
    }
}
