<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Estacionamientos extends Model
{
    protected $table = 'tms_am_parkinglots';
    protected $primaryKey = 'pk_parkinglot';
    public $timestamps = false;

    public function location(){
        return $this->belongsTo(Localizacion::class, 'fk_location');
    }

    public function entities_company()
    {
        return $this->belongsToMany(UnidadNegocio::class, 'tms_am_entity_parkinglot', 'fk_parkinglot', 'fk_entity_company');
    }

    public function vehicles(){
        return $this->hasMany(VehiculoGeneral::class, 'fk_parkinglot');
    }
}
