<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VehiculoGeneral extends Model
{
    protected $table = 'tms_am_vehicles';
    protected $primaryKey = 'pk_vehicle';
    public $timestamps = false;

    public function fuel(){
        return $this->belongsTo(Gasolina::class, 'fk_fuel');
    }

    public function insurance_info(){
        return $this->hasMany(ContratoAseguradora::class, 'fk_vehicle');
    }

    public function acquisition_info(){
        return $this->hasMany(Adquisicion::class, 'fk_vehicle');
    }

    public function parkinglot(){
        return $this->belongsTo(Estacionamientos::class, 'fk_parkinglot');
    }

    public function catalog_vehicle(){
        return $this->belongsTo(VehiculosCatalogo::class, 'fk_vehicle_catalog');
    }

    public function color(){
        return $this->belongsTo(Color::class, 'fk_color');
    }

    public function usage_vehicle(){
        return $this->belongsTo(Usages::class, 'fk_vehicle_usage');
    }

    public function documents(){
        return $this->hasMany(Docs::class, 'fk_vehicle');
    }

    public function images(){
        return $this->hasMany(Imagen::class, 'fk_vehicle');
    }
    
    public function complements()
    {
        return $this->belongsToMany(Complemento::class, 'tms_am_complement_vehicle', 'fk_vehicle', 'fk_complement');
    }
}
