<?php

namespace App\Rules;


class Rules implements Rule
{
    private $id_marca;
    private $id_plaza;
    private $id_rubro;
    private $id_region;

    public function _construct($id_plaza,$id_marca, $id_rubro, $id_region)
    {
        $this->id_marca = $id_marca;
        $this->id_plaza = $id_plaza;
        $this->id_rubro = $id_rubro;
        $this->id_region = $id_region;
    }

    public function passes($attribute, $value)
    {
        $uniqueRule = Rule::unique('marcas_plazas')
            ->where('id_marca', $this->id_marca)
            ->where('id_plaza', $this->id_plaza)
            ->where('id_rubro', $this->id_rubro)
            ->where('id_region', $this->id_region);

        return $uniqueRule;

    }

    public function message()
    {
        return "Ya existe la unidad de negocio";
    }
}
