<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmVehicleModelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_vehicle_models', function (Blueprint $table) {
            $table->id('pk_vehicle_model');
            $table->string('name');
            $table->integer('year');
            $table->unsignedBigInteger('fk_manufacturer');
            $table->boolean('status')->default(true);
            $table->foreign('fk_manufacturer')->references('pk_manufacturer')->on('tms_am_manufacturers');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_vehicle_models');
    }
}
