<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmVehicleCatalogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_vehicle_catalogs', function (Blueprint $table) {
            $table->id('pk_vehicle_catalog');
            $table->unsignedBigInteger('fk_vehicle_type');
            $table->string('version');
            $table->decimal('fuel_consumption_avg');
            $table->integer('fuel_capacity');
            $table->decimal('tax');
            $table->decimal('environment_tax');
            $table->unsignedBigInteger('fk_vehicle_model');
            $table->boolean('status')->default(true);
            $table->foreign('fk_vehicle_type')->references('pk_vehicle_type')->on('tms_am_vehicle_types');
            $table->foreign('fk_vehicle_model')->references('pk_vehicle_model')->on('tms_am_vehicle_models');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_vehicle_catalogs');
    }
}
