<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmEntitiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_entities', function (Blueprint $table) {
            $table->id('pk_entity');
            $table->string('name');
            $table->unsignedBigInteger('fk_entity_status')->nullable();
            $table->string('codename')->nullable();
            $table->unsignedBigInteger('fk_zone')->nullable();
            $table->boolean('status')->default(true);
            $table->foreign('fk_entity_status')->references('pk_entity_status')->on('tms_am_entity_status');
            $table->foreign('fk_zone')->references('pk_zone')->on('tms_am_zones');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_entities');
    }
}
