<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_locations', function (Blueprint $table) {
            $table->id('pk_location');
            $table->string('name');
            $table->string('street');
            $table->string('number');
            $table->boolean('headquarters')->default(false);
            $table->string('cp');
            $table->string('state');
            $table->string('country');
            $table->float('latitude')->default(0);
            $table->float('longitude')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_locations');
    }
}
