<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmParkinglotsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_parkinglots', function (Blueprint $table) {
            $table->id('pk_parkinglot');
            $table->string('codename');
            $table->float('rental');
            $table->integer('capacity_max_vehicles')->default(0);
            $table->integer('capacity_vehicles')->default(0);
            $table->unsignedBigInteger('fk_entity_company');
            $table->unsignedBigInteger('fk_location');
            $table->integer('fk_unit_rental')->nullable();
            $table->boolean('status')->default(true);
            $table->foreign('fk_entity_company')->references('pk_entity')->on('tms_am_entities');
            $table->foreign('fk_location')->references('pk_location')->on('tms_am_locations');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_parkinglots');
    }
}
