<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmVehiclesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_vehicles', function (Blueprint $table) {
            $table->id('pk_vehicle');
            $table->integer('eco');
            $table->unsignedBigInteger('fk_vehicle_catalog');
            $table->unsignedBigInteger('fk_color');
            $table->string('plates')->nullable();
            $table->string('federal_plates')->nullable();
            $table->string('fuel_consumption');
            $table->string('engine_number');
            $table->string('serial_number');
            $table->unsignedBigInteger('fk_parkinglot')->nullable();
            $table->unsignedBigInteger('fk_vehicle_status');
            $table->unsignedBigInteger('fk_entity_company');
            $table->unsignedBigInteger('fk_federal_entity');
            $table->string('passengers');
            $table->string('doors');
            $table->unsignedBigInteger('fk_seat_type');
            $table->unsignedBigInteger('fk_suspension_type');
            $table->string('description');
            $table->string('authorized_fuel_consumption');
            $table->unsignedBigInteger('fk_vehicle_usage');
            $table->unsignedBigInteger('fk_vehicle_status_group');
            $table->unsignedBigInteger('fk_vehicle_origin');
            $table->unsignedBigInteger('fk_vehicle_fleet');
            $table->unsignedBigInteger('fk_fuel');
            $table->unsignedBigInteger('capacity_tank_current')->nullable();
            $table->timestamp('last_updated_capacity_tank_current')->nullable();
            $table->boolean('status')->default(true);
            $table->foreign('fk_vehicle_catalog')->references('pk_vehicle_catalog')->on('tms_am_vehicle_catalogs');
            $table->foreign('fk_color')->references('pk_color')->on('tms_am_colors');
            $table->foreign('fk_parkinglot')->references('pk_parkinglot')->on('tms_am_parkinglots');
            $table->foreign('fk_vehicle_status')->references('pk_vehicle_status')->on('tms_am_vehicle_status');
            $table->foreign('fk_entity_company')->references('pk_entity')->on('tms_am_entities');
            $table->foreign('fk_federal_entity')->references('pk_federal_entity')->on('tms_am_federal_entities');
            $table->foreign('fk_seat_type')->references('pk_seat_type')->on('tms_am_seat_types');
            $table->foreign('fk_suspension_type')->references('pk_suspension_type')->on('tms_am_suspension_types');
            $table->foreign('fk_vehicle_usage')->references('pk_vehicle_usage')->on('tms_am_vehicle_usages');
            $table->foreign('fk_vehicle_status_group')->references('pk_vehicle_status_group')->on('tms_am_vehicle_status_groups');
            $table->foreign('fk_vehicle_origin')->references('pk_vehicle_origin')->on('tms_am_vehicle_origins');
            $table->foreign('fk_vehicle_fleet')->references('pk_vehicle_fleet')->on('tms_am_vehicle_fleets');
            $table->foreign('fk_fuel')->references('pk_fuel')->on('tms_am_fuels');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_vehicles');
    }
}
