<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmVehicleImagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_vehicle_images', function (Blueprint $table) {
            $table->id('pk_vehicle_image');
            $table->unsignedBigInteger('fk_vehicle');
            $table->string('url_image');
            $table->boolean('actual_image');
            $table->string('name_file');
            $table->date('upload_date');
            $table->boolean('status')->default(true);
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_vehicle_images');
    }
}
