<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmVehicleDocsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_vehicle_docs', function (Blueprint $table) {
            $table->id('pk_vehicle_doc');
            $table->unsignedBigInteger('fk_vehicle');
            $table->string('document_module');
            $table->string('url_file');
            $table->string('name_file');
            $table->timestamp('created_at');
            $table->boolean('status')->default(true);
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_vehicle_docs');
    }
}
