<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmGpsInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_gps_info', function (Blueprint $table) {
            $table->id('pk_gps_info');
            $table->bigInteger('sim');
            $table->decimal('activation_cost');
            $table->decimal('last_odometer_fuel_ticket');
            $table->string('imei');
            $table->unsignedBigInteger('fk_gps_provider');
            $table->unsignedBigInteger('fk_vehicle');
            $table->boolean('status')->default(true);
            $table->foreign('fk_gps_provider')->references('pk_gps_provider')->on('tms_am_gps_providers');
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_gps_info');
    }
}
