<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmAdvertisementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_advertisements', function (Blueprint $table) {
            $table->id('pk_advertisement');
            $table->unsignedBigInteger('fk_advertisement_client');
            $table->date('startup_date');
            $table->date('expiration_date');
            $table->unsignedBigInteger('fk_vehicle');
            $table->boolean('status')->default(true);
            $table->foreign('fk_advertisement_client')->references('pk_advertisement_client')->on('tms_am_advertisement_clients');
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_advertisements');
    }
}
