<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmVehicleComplementsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_vehicle_complements', function (Blueprint $table) {
            $table->id('pk_vehicle_complement');
            $table->string('name');
            $table->unsignedBigInteger('fk_complement_type');
            $table->boolean('status')->default(true);
            $table->foreign('fk_complement_type')->references('pk_complement_type')->on('tms_am_complement_types');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_vehicle_complements');
    }
}
