<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmEntityRelationshipsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_entity_relationships', function (Blueprint $table) {
            $table->unsignedBigInteger('fk_entity_type');
            $table->unsignedBigInteger('fk_entity');
            $table->foreign('fk_entity_type')->references('pk_entity_type')->on('tms_am_entity_types');
            $table->foreign('fk_entity')->references('pk_entity')->on('tms_am_entities');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_entity_relationships');
    }
}
