<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmInsurancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_insurances', function (Blueprint $table) {
            $table->id('pk_insurance');
            $table->string('name');
            $table->date('date_register');
            $table->unsignedBigInteger('fk_contact_service');
            $table->boolean('status')->default(true);
            $table->foreign('fk_contact_service')->references('pk_contact_service')->on('tms_am_contact_services');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_insurances');
    }
}
