<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmInsuranceContractsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_insurance_contracts', function (Blueprint $table) {
            $table->id('pk_insurance_contract');
            $table->string('insurance_subsection');
            $table->unsignedBigInteger('fk_insurance');
            $table->date('insurance_startup_date');
            $table->date('insurance_expiration_date');
            $table->unsignedBigInteger('fk_entity_company');
            $table->decimal('anual_contract_fee');
            $table->unsignedBigInteger('fk_vehicle');
            $table->boolean('status')->default(true);
            $table->foreign('fk_insurance')->references('pk_insurance')->on('tms_am_insurances');
            $table->foreign('fk_entity_company')->references('pk_entity')->on('tms_am_entities');
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_insurance_contracts');
    }
}
