<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTmsAmAcquisitionVehiclesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tms_am_acquisition_vehicles', function (Blueprint $table) {
            $table->id('pk_acq_vehicle');
            $table->unsignedBigInteger('fk_vehicle');
            $table->float('acquisition_mount');
            $table->date('acquisition_date');
            $table->string('acquisition_observations');
            $table->boolean('status')->default(true);
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tms_am_acquisition_vehicles');
    }
}
