<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateHistoricoPolizasAseguramientoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('historico_polizas_aseguramiento', function (Blueprint $table) {
            $table->id('pk_h_poliza_aseguramiento');
            $table->unsignedBigInteger('fk_vehicle');
            $table->unsignedBigInteger('fk_user');
            $table->string('url_file');
            $table->timestamp('fecha_transaccion');
            $table->foreign('fk_vehicle')->references('pk_vehicle')->on('tms_am_vehicles');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('historico_polizas_aseguramiento');
    }
}
